<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 10 templates -->
	
<xsl:template name="execution" >
    <div id="execution">
  <div class="contentwrapper">
    <div class="content">
      <div class="form1">
        <h2><strong>DOMESTIC MUNICIPAL ADVISOR EXECUTION </strong></h2>
        
        <p>You must complete the following execution page to Form MA. This execution page must be signed and attached to your initial application for <em>SEC</em> registration and all amendments to registration.</p>
        
        <h3>Appointment of Agent for Service of Process</h3>
        
        <p>By signing this Form MA, you, the undersigned advisor, irrevocably appoint the Secretary of State or other legally designated officer, of the state in which you maintain your <em>principal office and place of business</em>, as your agents to receive service, and agree that such <em>persons</em> may be served any process, pleadings, subpoenas, or other papers in (a) any <em>investigation</em> or administrative <em>proceeding</em> conducted by the <em>Commission</em> that relates to the applicant or about which the applicant may have information; and (b) any civil suit or action brought against the applicant or to which the applicant has been joined as defendant or respondent, in any appropriate court in any place subject to the jurisdiction of any state or of the United States of America or of any of its territories or possessions or of the District of Columbia, where the <em>investigation</em>, <em>proceeding</em> or cause of action arises out of or relates to or concerns <em>municipal advisory activities</em> of the <em>municipal advisor</em>.  The applicant stipulates and agrees that any such civil suit or action or administrative <em>proceeding</em> may be commenced by the service of process upon, and that service of an administrative subpoena shall be effected by service upon the above-named Agent for Service of Process, and that service as aforesaid shall be taken and held in all courts and administrative tribunals to be valid and binding as if personal service thereof had been made.</p>
        
        <h3>Signature</h3>
        <p>I, the undersigned, sign this Form MA on behalf of, and with the authority of, the <em>municipal advisor</em>.  The <em>municipal advisor</em> and I both certify, under penalty of perjury under the laws of the United States of America, that the information and statements made in this Form MA, including exhibits and any other information submitted, are true and correct, and that I am signing this Form MA as a free and voluntary act. </p>
        <p>I certify that the advisor&apos;s books and records will be preserved and available for inspection as required by law.  Finally, I authorize any <em>person</em> having custody or possession of these books and records to make them available to federal regulatory representatives. </p>
         
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
			<div class="tdStyle1 tdscheduleagridcol1" style="min-width: 500px; padding-left:15px;">
              
        		   <div class="fakeBox" >
                      <xsl:value-of
                          select="string(m1:formData/m1:maExecutionPage/m1:signature/ns1:signature)" />
                       
                     <span>
                         <xsl:text>&#160;</xsl:text>
                      </span>
                 </div>
                   Signature:</div>
              <div class="tdStyle1 tdscheduleagridcol1">
                  <div style="margin-left:0">
                <input name="textfield8" type="text" id="textfield17" value="mm/dd/yyyy" class="dateField" readonly="readonly">
                <xsl:attribute name="value">
				<xsl:value-of
					select="string(m1:formData/m1:maExecutionPage/m1:signature/ns1:date)" />
				</xsl:attribute>
                </input>
              </div>                
                  Date: </div>
            </div>
             <div style="clear:both;"></div>
            <div class="tableRow" style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <div class="tdStyle1 tdscheduleagridcrdcol1" style="min-width: 500px;">
                 <div class="fakeBox" >
                      <xsl:value-of
                         select="string(m1:formData/m1:maExecutionPage/m1:signature/ns1:signerName)" />
                     <span>
                         <xsl:text>&#160;</xsl:text>
                      </span>
                  </div>
                Printed Name:</div>
                <div class="tdStyle1 tdscheduleagridcol1">
                  <div style="margin-left:0">
                <input type="text" name="title3" readonly="readonly">
                <xsl:attribute name="value">
				<xsl:value-of
					select="string(m1:formData/m1:maExecutionPage/m1:crdNumber)" />
				</xsl:attribute>
                </input>
              </div>                
                Advisor <em>CRD </em>Number (if any):</div>
                </div>
                 <div style="clear:both;"></div>
             <div class="tableRow" style="width:100%; display:flex; margin-left:0; margin-right:0;">
               <div class="tdStyle1 tdscheduleagridcrdcol1" style="min-width: 500px;">
            
                <div class="fakeBox" >
                      <xsl:value-of
                         select="string(m1:formData/m1:maExecutionPage/m1:signature/ns1:title)" />
                     <span>
                         <xsl:text>&#160;</xsl:text>
                      </span>
                  </div>
              Title:</div>			  
            </div>
            <div style="clear:both;"></div>
          </div>
        
        <h2><strong>FORM MA <br/>APPLICATION FOR "MUNICIPAL ADVISOR REGISTRATION"</strong></h2> 
		
        <h2>NON-RESIDENT MUNICIPAL ADVISOR EXECUTION </h2>
        <p><b><u>Instructions</u>: If you are a <em>non-resident</em>, you must complete these steps:</b></p>
        <p><b>1. <u>Execution Page</u>:</b>  You must complete the following <em>non-resident</em> execution page to Form MA. This execution page must be signed and attached to your initial application for <em>SEC</em> registration and all amendments to registration.</p>
        <p><b>2. <u>Opinion of Counsel</u>:</b>  You must also attach to Form MA an Opinion of Counsel. See General Instructions.</p>
        <p><b>3. <u>Form MA-NR</u>:</b>  You must also attach to Form MA one or more executed Form MA-NR(s) for the <em>non-resident municipal advisor</em> applicant, and, if any, the <em>non-resident</em> general partner(s) and/or <em>non-resident managing agents</em>. See General Instructions for Form MA-NR.</p>
        
        <h3><em>Non-Resident Municipal Advisor</em> Undertaking Regarding Books and Records</h3>
        <p>By signing this Form MA, you agree to provide, at your own expense, to the U.S. Securities and Exchange Commission at its principal office in Washington D.C., at any Regional or District Office of the <em>Commission</em>, or at any one of its offices in the United States, as specified by the <em>Commission</em>, correct, current, and complete copies of any or all records that you are required to maintain by law.  This undertaking shall be binding upon you, your heirs, successors and assigns, and any <em>person</em> subject to your written irrevocable consents or powers of attorney or any of your general partners and <em>managing agents</em>.</p>
        <h3>Signature</h3>
        <p>I, the undersigned, sign this Form MA on behalf of, and with the authority of, the <em>non-resident municipal advisor</em>. The <em>municipal advisor</em> and I both certify, under penalty of perjury under the laws of the United States of America, that the information and statements made in this Form MA, including exhibits and any other information submitted, are true and correct, and that I am signing this Form MA as a free and voluntary act. </p>
        <p>I certify that the <em>municipal advisor&apos;s</em> books and records will be preserved and available for inspection as required by law. Finally, I authorize any <em>person</em> having custody or possession of these books and records to make them available to federal regulatory representatives.  Further, attached to this Form MA as an exhibit is an opinion of counsel that the <em>municipal advisor</em> can, as a matter of law, provide the <em>Commission</em> with access to the books and records of such <em>municipal advisor</em>, as required by law, and that the <em>municipal advisor</em> can, as a matter of law, submit to inspection and examination by the <em>Commission</em>.  Finally, attached as an exhibit to this Form MA is one or more executed Form MA-NR(s) for the <em>non-resident municipal advisor</em> applicant, and, if any, the <em>non-resident</em> general partner(s) and/or <em>non-resident managing agents</em>.         </p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
      <div class="tdStyle1 tdscheduleagridcol1" style="min-width: 500px;">
              
               <div class="fakeBox" >
                      <xsl:value-of
                        select="string(m1:formData/m1:maNRExecutionPage/m1:signature/ns1:signature)" />
                     <span>
                         <xsl:text>&#160;</xsl:text>
                      </span>
                  </div>
              Signature:</div>
            <div class="tdStyle1 tdscheduleagridcol1">
                  <div style="margin-left:0">
              <input name="textfield2" type="text" id="textfield2" value="mm/dd/yyyy" class="dateField" readonly="readonly">
              <xsl:attribute name="value">
				<xsl:value-of
					select="string(m1:formData/m1:maNRExecutionPage/m1:signature/ns1:date)" />
				</xsl:attribute>
              </input>
              </div>
              Date: </div>
          </div>
           <div style="clear:both;"></div>
            <div class="tableRow" style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <div class="tdStyle1 tdscheduleagridcrdcol1" style="min-width: 500px;">
                 <div class="fakeBox" >
                      <xsl:value-of
                        select="string(m1:formData/m1:maNRExecutionPage/m1:signature/ns1:signerName)" />
                     <span>
                         <xsl:text>&#160;</xsl:text>
                      </span>
                  </div>
              Printed Name:</div>
             <div class="tdStyle1 tdscheduleagridcol1">
                  <div style="margin-left:0">
              <input type="text" name="title4" readonly="readonly">
              <xsl:attribute name="value">
				<xsl:value-of
					select="string(m1:formData/m1:maNRExecutionPage/m1:crdNumber)" />
				</xsl:attribute>
              </input>              
              Advisor <em>CRD</em>  Number (if any):</div>
          </div>
           <div style="clear:both;"></div>
             <div class="tableRow" style="width:100%; display:flex; margin-left:0; margin-right:0;">
               <div class="tdStyle1 tdscheduleagridcrdcol1" style="min-width: 500px;">
            
                <div class="fakeBox" >
                      <xsl:value-of
                       select="string(m1:formData/m1:maNRExecutionPage/m1:signature/ns1:title)" />
                     <span>
                         <xsl:text>&#160;</xsl:text>
                      </span>
                  </div>
              Title:</div>
			  <div style="clear:both;"></div>
			  </div>
        </div>
        </div>
       
      </div>
    </div>
  </div>
</div>


</xsl:template>

</xsl:stylesheet>